/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dlg_Preferences.h"

dlg_Preferences::dlg_Preferences(QWidget *parent) : QDialog(parent)
{
    setupUi(this);
    connect(pb_DIR_CVS,      SIGNAL(clicked()), this, SLOT(slot_DIR_CVS()));
    connect(pb_DIR_SET,      SIGNAL(clicked()), this, SLOT(slot_DIR_SET()));
    connect(pb_DIR_CACHE,    SIGNAL(clicked()), this, SLOT(slot_DIR_CACHE()));
    connect(pb_PATH_AVRDUDE, SIGNAL(clicked()), this, SLOT(slot_PATH_AVRDUDE()));
}

void dlg_Preferences::set_Settings(cSettings *Set)
{
    Settings = Set;

    le_DIR_CVS->setText(Settings->DIR.Logging);
    le_DIR_SET->setText(Settings->DIR.Parameter);
    le_DIR_CACHE->setText(Settings->DIR.Cache);
    le_PATH_AVRDUDE->setText(Settings->DIR.AVRDUDE);
    le_TTY->setText(Settings->TTY.Port);
    sp_Plotter_Count->setValue(Settings->Data.Plotter_Count);
    sp_Debug_Fast->setValue(Settings->Data.Debug_Fast);
    sp_Debug_Slow->setValue(Settings->Data.Debug_Slow);
    sp_Debug_Off->setValue(Settings->Data.Debug_Off);
    sp_Navi_Fast->setValue(Settings->Data.Navi_Fast);
    sp_Navi_Slow->setValue(Settings->Data.Navi_Slow);
    sp_Navi_Off->setValue(Settings->Data.Navi_Off);
    le_ServerPort->setText(Settings->Server.Port);
    cb_StartServer->setChecked(Settings->Server.StartServer);
    cb_ToGround->setChecked(Settings->Server.ToGround);
    le_Login->setText(Settings->Server.QMKS_Login);
    le_Password->setText(Settings->Server.QMKS_Password);
    le_QMKS_Host->setText(Settings->Server.QMKS_Host);
    le_QMKS_Port->setText(Settings->Server.QMKS_Port);
}

cSettings *dlg_Preferences::get_Settings()
{
    Settings->TTY.Port             = le_TTY->text();
    Settings->Data.Plotter_Count   = sp_Plotter_Count->value();
    Settings->Data.Debug_Fast      = sp_Debug_Fast->value();
    Settings->Data.Debug_Slow      = sp_Debug_Slow->value();
    Settings->Data.Debug_Off       = sp_Debug_Off->value();
    Settings->Data.Navi_Fast       = sp_Navi_Fast->value();
    Settings->Data.Navi_Slow       = sp_Navi_Slow->value();
    Settings->Data.Navi_Off        = sp_Navi_Off->value();
    Settings->Server.Port          = le_ServerPort->text();
    Settings->Server.StartServer   = cb_StartServer->isChecked();
    Settings->Server.ToGround      = cb_ToGround->isChecked();
    Settings->Server.QMKS_Login    = le_Login->text();
    Settings->Server.QMKS_Password = le_Password->text();
    Settings->Server.QMKS_Host     = le_QMKS_Host->text();
    Settings->Server.QMKS_Port     = le_QMKS_Port->text();

    return Settings;
}

// Configuration -> Verzeichnisse
/////////////////////////////////
void dlg_Preferences::slot_DIR_CVS()
{
    QString directory = QFileDialog::getExistingDirectory(this, trUtf8("Verzeichniss für Daten"), Settings->DIR.Logging, QFileDialog::DontResolveSymlinks | QFileDialog::ShowDirsOnly);

    if ((!directory.isEmpty()) && (Settings->DIR.Logging != directory))
    {
        Settings->DIR.Logging = directory;
        le_DIR_CVS->setText(Settings->DIR.Logging);
    }
}

void dlg_Preferences::slot_DIR_SET()
{
    QString directory = QFileDialog::getExistingDirectory(this, trUtf8("Verzeichniss für Settings-Dateien"), Settings->DIR.Parameter, QFileDialog::DontResolveSymlinks | QFileDialog::ShowDirsOnly);

    if ((!directory.isEmpty()) && (Settings->DIR.Parameter != directory))
    {
        Settings->DIR.Parameter = directory;
        le_DIR_SET->setText(Settings->DIR.Parameter);
    }

}
void dlg_Preferences::slot_DIR_CACHE()
{
    QString directory = QFileDialog::getExistingDirectory(this, trUtf8("Verzeichniss für Karten-Cache"), Settings->DIR.Cache, QFileDialog::DontResolveSymlinks | QFileDialog::ShowDirsOnly);

    if ((!directory.isEmpty()) && (Settings->DIR.Cache != directory))
    {
        Settings->DIR.Cache = directory;
        le_DIR_CACHE->setText(Settings->DIR.Cache);
    }
}

void dlg_Preferences::slot_PATH_AVRDUDE()
{
    QString directory = QFileDialog::getOpenFileName(this, trUtf8("Pfad zu AVRDUDE"), Settings->DIR.AVRDUDE, tr("AVRDUDE (*)"));


    if ((!directory.isEmpty()) && (Settings->DIR.AVRDUDE != directory))
    {
        Settings->DIR.AVRDUDE = directory;
        le_PATH_AVRDUDE->setText(Settings->DIR.AVRDUDE);
    }
}

dlg_Preferences::~dlg_Preferences()
{
}


